﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.MT;
using BMS.DataContracts;

namespace BMS.Translators
{
    public static class TranslatorIconOrder
    {
        public static void CopyTo(this List<DataContracts.IconOrder> iconOrderList, IconOrderBO iconOrderBO)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                iconOrderBO.FACILITY_UID.Value = Guid.Parse(iconOrderList[0].FacilityId.extension);
                StringBuilder sb = new StringBuilder();
                foreach (DataContracts.IconOrder io in iconOrderList)
                {
                    sb.Append(io.IconId);
                    sb.Append(",");
                    sb.Append(io.OrderIndex);
                    sb.Append(",");
                }
                iconOrderBO.ICON_ID_ORDER_LIST.Value = sb.ToString();                
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
